/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.support;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.rfc.MiddlewareRFC;
import com.sap.mw.jco.support.RfcTest;
import java.util.Date;
import java.util.Properties;

public class JRfcServ
extends RfcTest
implements JCO.ServerStateChangedListener,
JCO.ServerExceptionListener,
JCO.ServerErrorListener {
    private static Properties props = new Properties();
    private static boolean startedServ = false;
    private static IRepository repository;

    public static void main(String[] args) {
        if (args.length == 0) {
            JRfcServ.usage();
        } else {
            try {
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("-t")) {
                        props.setProperty("jco.server.trace", "true");
                        int jco_trc_level = Integer.parseInt(args[i].substring(2));
                        JCO.setTracePath(".");
                        JCO.setTraceLevel(jco_trc_level);
                    } else if (args[i].startsWith("-a")) {
                        props.setProperty("jco.server.progid", args[i].substring(2));
                    } else if (args[i].startsWith("-g")) {
                        props.setProperty("jco.server.gwhost", args[i].substring(2));
                    } else if (args[i].startsWith("-x")) {
                        props.setProperty("jco.server.gwserv", args[i].substring(2));
                    } else if (args[i].startsWith("-F")) {
                        props.setProperty("jco.server.profile_name", args[i].substring(2));
                    } else if (args[i].startsWith("-L")) {
                        props.setProperty("jco.server.snc_lib", args[i].substring(2));
                    } else if (args[i].startsWith("-S")) {
                        props.setProperty("jco.server.snc_myname", args[i].substring(2));
                    } else if (args[i].startsWith("-Q")) {
                        props.setProperty("jco.server.snc_qop", args[i].substring(2));
                    } else if (args[i].startsWith("-u")) {
                        props.setProperty("jco.server.unicode", "true");
                    } else if (args[i].startsWith("-C")) {
                        props.setProperty("jco.client.client", args[i].substring(2));
                        startedServ = true;
                    } else if (args[i].startsWith("-U")) {
                        props.setProperty("jco.client.user", args[i].substring(2));
                    } else if (args[i].startsWith("-P")) {
                        props.setProperty("jco.client.passwd", args[i].substring(2));
                    } else if (args[i].startsWith("-H")) {
                        props.setProperty("jco.client.ashost", args[i].substring(2));
                    } else if (args[i].startsWith("-N")) {
                        props.setProperty("jco.client.sysnr", args[i].substring(2));
                    }
                    ++i;
                }
                if (startedServ) {
                    JRfcServ.startServer(args, props);
                } else {
                    JRfcServ.startServer(props, JRfcServ.getClientProperties(props));
                }
            }
            catch (Exception ex) {
                RfcTest.displayException(ex);
                JRfcServ.usage();
            }
        }
    }

    private static Properties getClientProperties(Properties serverProps) {
        Properties props = RfcTest.loadProperties("jrfcserv.props");
        RfcTest.out.println("Please enter properties for repository connections: ");
        String answer = "n";
        while (!answer.startsWith("y") && !answer.startsWith("Y")) {
            props.setProperty("jco.client.client", RfcTest.ask("client", props.getProperty("jco.client.client", "000")));
            props.setProperty("jco.client.user", RfcTest.ask("user", props.getProperty("jco.client.user", "")));
            props.setProperty("jco.client.passwd", RfcTest.ask("password", "XXXXXX"));
            props.setProperty("jco.client.ashost", RfcTest.ask("application host", props.getProperty("jco.client.ashost", serverProps.getProperty("jco.server.gwhost", ""))));
            props.setProperty("jco.client.sysnr", RfcTest.ask("system number", props.getProperty("jco.client.sysnr", serverProps.getProperty("jco.server.gwserv", "gwserv").substring(6))));
            answer = RfcTest.ask("start with properties (y/n)", "y");
        }
        RfcTest.storeProperties(props, "jrfcserv.props", "client properties");
        return props;
    }

    private static void startServer(Properties serverP, Properties repositoryP) {
        RfcTest.out.println("Start server");
        RfcTest.displayProperties(serverP);
        RfcTest.displayProperties(repositoryP);
        JRfcServ listener = new JRfcServ();
        JCO.addServerStateChangedListener(listener);
        JCO.addServerExceptionListener(listener);
        JCO.addServerErrorListener(listener);
        JCO.Client c = JCO.createClient(repositoryP);
        c.connect();
        c.ping();
        JRfcServer server = new JRfcServer(serverP, JCO.createRepository("REP", c));
        server.start();
    }

    private static void startServer(String[] serverStmp, Properties repositoryP) {
        RfcTest.out.println("Start server");
        JRfcServ listener = new JRfcServ();
        JCO.addServerStateChangedListener(listener);
        JCO.addServerExceptionListener(listener);
        JCO.addServerErrorListener(listener);
        JCO.Client c = JCO.createClient(repositoryP);
        c.connect();
        c.ping();
        String[] serverS = new String[serverStmp.length - 5];
        int i = 0;
        while (i < serverS.length) {
            serverS[i] = serverStmp[i + 5];
            ++i;
        }
        JRfcServer server = new JRfcServer(serverS, JCO.createRepository("REP", c));
        server.start();
    }

    public void serverStateChangeOccurred(JCO.Server server, int old_state, int new_state) {
        if (server.getThread() != null) {
            RfcTest.out.println(server.getThread().getName() + "[handle: " + server.getConnectionHandle() + "] changed state from " + RfcTest.stateToString(old_state) + " to " + RfcTest.stateToString(new_state));
            if (startedServ && (old_state & 4) != 0 && (new_state & 4) == 0) {
                server.stop();
            }
        } else {
            RfcTest.out.println(Thread.currentThread().getName() + " Server thread is null");
        }
    }

    public void serverExceptionOccurred(JCO.Server server, Exception ex) {
        RfcTest.out.println("Exception in server " + server.getProgID() + " [handle: " + server.getConnectionHandle() + "]");
        RfcTest.displayException(ex);
    }

    public void serverErrorOccurred(JCO.Server server, Error ex) {
        RfcTest.out.println("Error in server " + server.getProgID() + " [handle: " + server.getConnectionHandle() + "]");
        RfcTest.displayException(ex);
    }

    private static void usage() {
        RfcTest.out.println("\nSyntax for start and run in registered mode or via fastrfc:");
        RfcTest.out.println("        JRfcServ [options]");
        RfcTest.out.println();
        RfcTest.out.println("options = -a<program ID>                   e.g.  <own host name>.srfcserv");
        RfcTest.out.println("        = -g<SAP gateway host name>        e.g.  hs0311");
        RfcTest.out.println("        = -x<SAP gateway service>          e.g.  sapgw53");
        RfcTest.out.println("        = -F<profile name>                 e.g.  C:\\\\profile\\\\B6Q_D25_PWDF0633");
        RfcTest.out.println("        = -u                               only for unicode server");
        RfcTest.out.println("        = -t<Level>    RFC/JCo-Trace on    e.g.  5");
        RfcTest.out.println("        = -L<SNC library, optional>");
        RfcTest.out.println("        = -S<SNC myname, optional>");
        RfcTest.out.println("        = -Q<SNC quality of protection, optional>");
        RfcTest.out.println();
        RfcTest.out.println("Option L, S and Q can be set if working with SNC (Secure Network");
        RfcTest.out.println("Communication). In order to register a server at a gateway use");
        RfcTest.out.println("options a, g and x. For fastrfc apply the option profile_name.");
        RfcTest.out.println();
    }

    protected static class JRfcServer
    extends JCO.Server {
        IRepository rep;

        JRfcServer(Properties serverP, IRepository repository) {
            super(serverP, repository);
            this.rep = repository;
        }

        JRfcServer(String[] serverS, IRepository repository) {
            super(serverS, repository);
            this.rep = repository;
        }

        protected JCO.Function getFunction(String function_name) {
            try {
                IFunctionTemplate ft = null;
                ft = this.rep.getFunctionTemplate(function_name);
                return ft != null ? new JCO.Function(ft) : null;
            }
            catch (Exception ex) {
                RfcTest.displayException(ex);
                return null;
            }
        }

        protected void handleRequest(JCO.Function function) {
            try {
                JCO.ParameterList imp = function.getImportParameterList();
                JCO.ParameterList exp = function.getExportParameterList();
                JCO.ParameterList tab = function.getTableParameterList();
                JCO.Attributes a = this.getAttributes();
                RfcTest.out.println("Start function '" + function.getName() + "'");
                RfcTest.out.println("Attributes:\n" + a.toString());
                if (function.getName().equals("STFC_CONNECTION")) {
                    exp.setValue(imp.getString("REQUTEXT"), "ECHOTEXT");
                    exp.setValue("SAP R/3 Rel " + a.getRelease() + "    Sysid: " + a.getSystemID() + "    Date: " + new Date().toString() + "    Logon Data: " + a.getClient() + "/" + a.getUser().trim() + "/" + a.getLanguage(), "RESPTEXT");
                } else if (function.getName().equals("STFC_PERFORMANCE")) {
                    String resultInfo = null;
                    String returnCode = "O";
                    resultInfo = this.checkTable(tab.getTable("ITAB0332"), "0332", imp.getInt("LGIT0332"), imp.getString("CHECKTAB"));
                    if (!resultInfo.endsWith("K")) {
                        returnCode = "E";
                    }
                    exp.setValue(resultInfo, "TEXT0332");
                    resultInfo = this.checkTable(tab.getTable("ITAB1000"), "1000", imp.getInt("LGIT1000"), imp.getString("CHECKTAB"));
                    if (!resultInfo.endsWith("K")) {
                        returnCode = "E";
                    }
                    exp.setValue(resultInfo, "TEXT1000");
                    exp.setValue(returnCode, "EXITCODE");
                    if (returnCode.equals("O")) {
                        this.fillTable(tab.getTable("ETAB0332"), imp.getInt("LGET0332"));
                        this.fillTable(tab.getTable("ETAB1000"), imp.getInt("LGET1000"));
                    }
                } else if (function.getName().equals("STFC_STRUCTURE")) {
                    JCO.Structure is = imp.getStructure("IMPORTSTRUCT");
                    JCO.Structure es = exp.getStructure("ECHOSTRUCT");
                    es.setValue(is.getDouble("RFCFLOAT") + 1.0, "RFCFLOAT");
                    es.setValue('X', "RFCCHAR1");
                    es.setValue(is.getInt("RFCINT2") + 1, "RFCINT2");
                    es.setValue(is.getInt("RFCINT1") + 1, "RFCINT1");
                    es.setValue(a.getSystemID(), "RFCCHAR4");
                    es.setValue(is.getInt("RFCINT4") + 1, "RFCINT4");
                    es.setValue(new byte[]{-15, -14, -13}, "RFCHEX3");
                    es.setValue("YZ", "RFCCHAR2");
                    es.setValue((Object)new Date(), "RFCTIME");
                    es.setValue((Object)new Date(), "RFCDATE");
                    es.setValue(is.getString("RFCDATA1"), "RFCDATA1");
                    es.setValue(is.getString("RFCDATA2"), "RFCDATA2");
                    JCO.Table t = tab.getTable("RFCTABLE");
                    t.copyFrom(es);
                    exp.setValue(is, "ECHOSTRUCT");
                    exp.setValue("SAP R/3 Rel " + a.getRelease() + "    Sysid: " + a.getSystemID() + "    Date: " + new Date().toString() + "    Logon Data: " + a.getClient() + "/" + a.getUser().trim() + "/" + a.getLanguage(), "RESPTEXT");
                } else if (function.getName().equals("STFC_CONNECTION_BACK")) {
                    int NRBACK = imp.getInt("NRBACK");
                    JCO.Function back_func = this.getFunction("STFC_CONNECTION");
                    try {
                        int i = 0;
                        while (i < NRBACK) {
                            back_func.getExportParameterList().setValue(imp.getString("REQUTEXT"), "REQUTEXT");
                            ((MiddlewareRFC.Server)this.getMiddlewareImplementation()).execute(this, back_func);
                            exp.setValue(back_func.getExportParameterList().getValue("RESPTEXT"), "RESPTEXT");
                            exp.setValue(back_func.getExportParameterList().getValue("ECHOTEXT"), "ECHOTEXT");
                            exp.setValue(i, "NOBACK");
                            ++i;
                        }
                        exp.setValue("SAP R/3 Rel " + a.getRelease() + " Sysid " + a.getSystemID() + " Logon data " + a.getClient() + " " + a.getUser() + " " + new Date().toString(), "RESPTEXT");
                    }
                    catch (Exception ex) {
                        RfcTest.displayException(ex);
                        exp.setValue(ex.getMessage(), "RESPTEXT");
                    }
                } else if (function.getName().equals("STFC_STRING")) {
                    if (imp.getString("QUESTION").equalsIgnoreCase("How are you")) {
                        exp.setValue("Fine thanks.", "MYANSWER");
                    } else {
                        exp.setValue("Sorry, I can not understand you.", "MYANSWER");
                    }
                } else {
                    RfcTest.out.println("Function '" + function.getName() + "' not supported.");
                }
            }
            catch (Exception ex) {
                RfcTest.out.println("Exception in server " + this.getProgID() + " [handle: " + this.getConnectionHandle() + "]");
                RfcTest.displayException(ex);
            }
        }

        private String checkTable(JCO.Table tab, String type, int len, String checkTab) {
            int numberOfRows = tab.getNumRows();
            String returnMess = "Export table (length " + type + "):";
            if (numberOfRows != len) {
                returnMess = returnMess + "  ERROR:  #Lines = " + numberOfRows + "  Expected: " + len;
            } else if (!checkTab.toUpperCase().equals("Y")) {
                returnMess = returnMess + "  #Lines = " + numberOfRows + ": OK,  Contents: NO CHECK";
            } else {
                if (!tab.isEmpty()) {
                    String field = "";
                    int pos = 0;
                    int value = 0;
                    int i = 0;
                    while (i < numberOfRows) {
                        tab.setRow(i);
                        int j = 0;
                        while (j < tab.getNumColumns()) {
                            field = tab.getString(j);
                            pos = j == 0 ? 40 : 0;
                            int k = pos;
                            while (k < field.length()) {
                                value = k % 10;
                                if (!field.substring(k, k + 1).equals(String.valueOf(value))) {
                                    returnMess = returnMess + " ERROR at line " + (i + 1) + " position " + k + ":  " + field.substring(k, k + 1) + "/" + value;
                                    return returnMess;
                                }
                                ++k;
                            }
                            if (field.length() < tab.getField(j).getLength()) {
                                int expectValue;
                                int currPos;
                                if (j == 0 && field.length() < 40) {
                                    currPos = 40;
                                    expectValue = 0;
                                } else {
                                    currPos = field.length();
                                    expectValue = field.length() % 10;
                                }
                                returnMess = returnMess + " ERROR at line " + (i + 1) + " position " + currPos + ":   /" + expectValue;
                                return returnMess;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                returnMess = returnMess + "  #Lines = " + numberOfRows + ": OK,  Contents: OK";
            }
            return returnMess;
        }

        private void fillTable(JCO.Table tab, int len) {
            if (len < 1) {
                return;
            }
            tab.deleteAllRows();
            tab.appendRows(len);
            int i = 0;
            while (i < len) {
                tab.setRow(i);
                String field = "Line Length: " + tab.getTabLength() + " Line No.: " + (i + 1);
                int j = field.length();
                while (j < 40) {
                    field = field + " ";
                    ++j;
                }
                int pos = 0;
                int j2 = 0;
                while (j2 < tab.getNumColumns()) {
                    if (j2 == 0) {
                        pos = 40;
                    } else {
                        pos = 0;
                        field = "";
                    }
                    int k = pos;
                    while (k < tab.getField(j2).getLength()) {
                        field = field + String.valueOf(k % 10);
                        ++k;
                    }
                    tab.setValue(field, j2);
                    ++j2;
                }
                ++i;
            }
        }
    }
}

