/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.support;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.support.RfcTest;
import java.util.Date;
import java.util.Properties;

public class JTRfcServ
extends RfcTest
implements JCO.ServerStateChangedListener,
JCO.ServerExceptionListener,
JCO.ServerErrorListener {
    private static Properties props = new Properties();
    private static boolean startedServ = false;
    private static IRepository repository;

    public static void main(String[] args) {
        if (args.length == 0) {
            JTRfcServ.usage();
        } else {
            try {
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("-t")) {
                        props.setProperty("jco.server.trace", "true");
                        int jco_trc_level = Integer.parseInt(args[i].substring(2));
                        JCO.setTracePath(".");
                        JCO.setTraceLevel(jco_trc_level);
                    } else if (args[i].startsWith("-a")) {
                        props.setProperty("jco.server.progid", args[i].substring(2));
                    } else if (args[i].startsWith("-g")) {
                        props.setProperty("jco.server.gwhost", args[i].substring(2));
                    } else if (args[i].startsWith("-x")) {
                        props.setProperty("jco.server.gwserv", args[i].substring(2));
                    } else if (args[i].startsWith("-F")) {
                        props.setProperty("jco.server.profile_name", args[i].substring(2));
                    } else if (args[i].startsWith("-L")) {
                        props.setProperty("jco.server.snc_lib", args[i].substring(2));
                    } else if (args[i].startsWith("-S")) {
                        props.setProperty("jco.server.snc_myname", args[i].substring(2));
                    } else if (args[i].startsWith("-Q")) {
                        props.setProperty("jco.server.snc_qop", args[i].substring(2));
                    } else if (args[i].startsWith("-u")) {
                        props.setProperty("jco.server.unicode", "true");
                    } else if (args[i].startsWith("-C")) {
                        props.setProperty("jco.client.client", args[i].substring(2));
                        startedServ = true;
                    } else if (args[i].startsWith("-U")) {
                        props.setProperty("jco.client.user", args[i].substring(2));
                    } else if (args[i].startsWith("-P")) {
                        props.setProperty("jco.client.passwd", args[i].substring(2));
                    } else if (args[i].startsWith("-H")) {
                        props.setProperty("jco.client.ashost", args[i].substring(2));
                    } else if (args[i].startsWith("-N")) {
                        props.setProperty("jco.client.sysnr", args[i].substring(2));
                    }
                    ++i;
                }
                if (startedServ) {
                    JTRfcServ.startServer(args, props);
                } else {
                    JTRfcServ.startServer(props, JTRfcServ.getClientProperties(props));
                }
            }
            catch (Exception ex) {
                RfcTest.displayException(ex);
                JTRfcServ.usage();
            }
        }
    }

    private static Properties getClientProperties(Properties serverProps) {
        Properties props = RfcTest.loadProperties("jrfcserv.props");
        RfcTest.out.println("Please enter properties for repository connections: ");
        String answer = "n";
        while (!answer.startsWith("y") && !answer.startsWith("Y")) {
            props.setProperty("jco.client.client", RfcTest.ask("client", props.getProperty("jco.client.client", "000")));
            props.setProperty("jco.client.user", RfcTest.ask("user", props.getProperty("jco.client.user", "")));
            props.setProperty("jco.client.passwd", RfcTest.ask("password", "XXXXXX"));
            props.setProperty("jco.client.ashost", RfcTest.ask("application host", props.getProperty("jco.client.ashost", serverProps.getProperty("jco.server.gwhost", ""))));
            props.setProperty("jco.client.sysnr", RfcTest.ask("system number", props.getProperty("jco.client.sysnr", serverProps.getProperty("jco.server.gwserv", "gwserv").substring(6))));
            answer = RfcTest.ask("start with properties (y/n)", "y");
        }
        RfcTest.storeProperties(props, "jrfcserv.props", "client properties");
        return props;
    }

    private static void startServer(Properties serverP, Properties repositoryP) {
        RfcTest.out.println("Start server");
        RfcTest.displayProperties(serverP);
        RfcTest.displayProperties(repositoryP);
        JTRfcServ listener = new JTRfcServ();
        JCO.addServerStateChangedListener(listener);
        JCO.addServerExceptionListener(listener);
        JCO.addServerErrorListener(listener);
        JCO.Client c = JCO.createClient(repositoryP);
        c.connect();
        c.ping();
        JTRfcServer server = new JTRfcServer(serverP, JCO.createRepository("REP", c));
        server.start();
    }

    private static void startServer(String[] serverStmp, Properties repositoryP) {
        RfcTest.out.println("Start server");
        JTRfcServ listener = new JTRfcServ();
        JCO.addServerStateChangedListener(listener);
        JCO.addServerExceptionListener(listener);
        JCO.addServerErrorListener(listener);
        JCO.Client c = JCO.createClient(repositoryP);
        c.connect();
        c.ping();
        String[] serverS = new String[serverStmp.length - 5];
        int i = 0;
        while (i < serverS.length) {
            serverS[i] = serverStmp[i + 5];
            ++i;
        }
        JTRfcServer server = new JTRfcServer(serverS, JCO.createRepository("REP", c));
        server.start();
    }

    public void serverStateChangeOccurred(JCO.Server server, int old_state, int new_state) {
        if (server.getThread() != null) {
            RfcTest.out.println(server.getThread().getName() + "[handle: " + server.getConnectionHandle() + "] changed state from " + RfcTest.stateToString(old_state) + " to " + RfcTest.stateToString(new_state));
            if (startedServ && (old_state & 4) != 0 && (new_state & 4) == 0) {
                server.stop();
            }
        } else {
            RfcTest.out.println(Thread.currentThread().getName() + " Server thread is null");
        }
    }

    public void serverExceptionOccurred(JCO.Server server, Exception ex) {
        RfcTest.out.println("Exception in server " + server.getProgID() + " [handle: " + server.getConnectionHandle() + "]");
        RfcTest.displayException(ex);
    }

    public void serverErrorOccurred(JCO.Server server, Error ex) {
        RfcTest.out.println("Error in server " + server.getProgID() + " [handle: " + server.getConnectionHandle() + "]");
        RfcTest.displayException(ex);
    }

    private static void usage() {
        RfcTest.out.println("\nSyntax for start and run in registered mode or via fastrfc:");
        RfcTest.out.println("        JRfcServ [options]");
        RfcTest.out.println();
        RfcTest.out.println("options = -a<program ID>                   e.g.  <own host name>.srfcserv");
        RfcTest.out.println("        = -g<SAP gateway host name>        e.g.  hs0311");
        RfcTest.out.println("        = -x<SAP gateway service>          e.g.  sapgw53");
        RfcTest.out.println("        = -F<profile name>                 e.g.  C:\\\\profile\\\\B6Q_D25_PWDF0633");
        RfcTest.out.println("        = -u                               only for unicode server");
        RfcTest.out.println("        = -t<Level>    RFC/JCo-Trace on    e.g.  5");
        RfcTest.out.println("        = -L<SNC library, optional>");
        RfcTest.out.println("        = -S<SNC myname, optional>");
        RfcTest.out.println("        = -Q<SNC quality of protection, optional>");
        RfcTest.out.println();
        RfcTest.out.println("Option L, S and Q can be set if working with SNC (Secure Network");
        RfcTest.out.println("Communication). In order to register a server at a gateway use");
        RfcTest.out.println("options a, g and x. For fastrfc apply the option profile_name.");
        RfcTest.out.println();
    }

    protected static class JTRfcServer
    extends JCO.Server {
        IRepository rep;
        RfcTest.TidManager tidManager;

        JTRfcServer(Properties serverP, IRepository repository) {
            super(serverP, repository);
            this.rep = repository;
            this.tidManager = new RfcTest.TidManager("trfcserv.tid");
        }

        JTRfcServer(String[] serverS, IRepository repository) {
            super(serverS, repository);
            this.rep = repository;
            this.tidManager = new RfcTest.TidManager("trfcserv.tid");
        }

        protected boolean onCheckTID(String tid) {
            this.tidManager.update_TID(tid, "CHECKED");
            System.out.println("onCheckTID(" + tid + ") returns true");
            return true;
        }

        protected void onConfirmTID(String tid) {
            this.tidManager.update_TID(tid, "CONFIRMED");
            System.out.println("onConfirmTID(" + tid + ") ");
        }

        protected void onCommit(String tid) {
            this.tidManager.update_TID(tid, "COMMITED");
            System.out.println("onCommit(" + tid + ") ");
        }

        protected void onRollback(String tid) {
            this.tidManager.update_TID(tid, "ROLLBACKED");
            System.out.println("onRollbac(" + tid + ") ");
        }

        protected JCO.Function getFunction(String function_name) {
            try {
                IFunctionTemplate ft = null;
                ft = this.rep.getFunctionTemplate(function_name);
                return ft != null ? new JCO.Function(ft) : null;
            }
            catch (Exception ex) {
                RfcTest.displayException(ex);
                return null;
            }
        }

        protected void handleRequest(JCO.Function function) {
            try {
                JCO.ParameterList imp = function.getImportParameterList();
                JCO.ParameterList exp = function.getExportParameterList();
                JCO.ParameterList tab = function.getTableParameterList();
                JCO.Attributes a = this.getAttributes();
                RfcTest.out.println("Start function '" + function.getName() + "'");
                RfcTest.out.println("Attributes:\n" + a.toString());
                if (function.getName().equals("STFC_CONNECTION")) {
                    exp.setValue(imp.getString("REQUTEXT"), "ECHOTEXT");
                    exp.setValue("SAP R/3 Rel " + a.getRelease() + "    Sysid: " + a.getSystemID() + "    Date: " + new Date().toString() + "    Logon Data: " + a.getClient() + "/" + a.getUser().trim() + "/" + a.getLanguage(), "RESPTEXT");
                } else if (function.getName().equals("STFC_WRITE_TO_TCPIC")) {
                    System.out.println("handle 'STFC_WRITE_TO_TCPIC'");
                } else {
                    RfcTest.out.println("Function '" + function.getName() + "' not supported.");
                }
            }
            catch (Exception ex) {
                RfcTest.out.println("Exception in server " + this.getProgID() + " [handle: " + this.getConnectionHandle() + "]");
                RfcTest.displayException(ex);
            }
        }
    }
}

