/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import com.sun.jna.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerHost;
import org.springframework.boot.buildpack.platform.system.Environment;

public class ResolvedDockerHost
extends DockerHost {
    private static final String UNIX_SOCKET_PREFIX = "unix://";
    private static final String DOMAIN_SOCKET_PATH = "/var/run/docker.sock";
    private static final String WINDOWS_NAMED_PIPE_PATH = "//./pipe/docker_engine";
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";

    ResolvedDockerHost(String address, boolean secure, String certificatePath) {
        super(address, secure, certificatePath);
    }

    @Override
    public String getAddress() {
        return super.getAddress().startsWith(UNIX_SOCKET_PREFIX) ? super.getAddress().substring(UNIX_SOCKET_PREFIX.length()) : super.getAddress();
    }

    public boolean isRemote() {
        return this.getAddress().startsWith("http") || this.getAddress().startsWith("tcp");
    }

    public boolean isLocalFileReference() {
        try {
            return Files.exists(Paths.get(this.getAddress(), new String[0]), new LinkOption[0]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ResolvedDockerHost from(DockerHost dockerHost) {
        return ResolvedDockerHost.from(Environment.SYSTEM, dockerHost);
    }

    static ResolvedDockerHost from(Environment environment, DockerHost dockerHost) {
        if (environment.get(DOCKER_HOST) != null) {
            return new ResolvedDockerHost(environment.get(DOCKER_HOST), ResolvedDockerHost.isTrue(environment.get(DOCKER_TLS_VERIFY)), environment.get(DOCKER_CERT_PATH));
        }
        if (dockerHost != null && dockerHost.getAddress() != null) {
            return new ResolvedDockerHost(dockerHost.getAddress(), dockerHost.isSecure(), dockerHost.getCertificatePath());
        }
        return new ResolvedDockerHost(Platform.isWindows() ? WINDOWS_NAMED_PIPE_PATH : DOMAIN_SOCKET_PATH, false, null);
    }

    private static boolean isTrue(String value) {
        try {
            return value != null && Integer.parseInt(value) == 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

