/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.AboutDialog;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class About
extends AboutDialog {
    public static final String VERSION = "2.1.10 (2011-05-10)";
    private static final String NOT_FOUND = "Library not found";
    private static final String SYS_PATH = "System defined path";

    public About() {
        super("SAP Java Connector");
        String libjco_path = null;
        String jco_version = VERSION;
        String middleware_version = "unknown";
        String libjrfc_version = "unknown";
        String libjrfc_path = null;
        String librfc_numversion = "unknown";
        String librfc_path = null;
        String sap_codepage = null;
        String rfc_trace = null;
        String cpic_trace = null;
        String jco_error = null;
        try {
            libjco_path = this.getOwnFilePath();
            jco_version = JCO.getVersion();
            middleware_version = JCO.getMiddlewareVersion();
            libjrfc_version = JCO.getMiddlewareProperty("jco.middleware.libjrfc_version");
            libjrfc_path = JCO.getMiddlewareProperty("jco.middleware.libjrfc_path");
            librfc_numversion = JCO.getMiddlewareProperty("jco.middleware.librfc_numversion");
            librfc_path = JCO.getMiddlewareProperty("jco.middleware.librfc_path");
            sap_codepage = JCO.getMiddlewareProperty("jco.middleware.librfc_sap_codepage");
            rfc_trace = JCO.getMiddlewareProperty("jco.middleware.librfc_rfc_trace");
            cpic_trace = JCO.getMiddlewareProperty("jco.middleware.librfc_cpic_trace");
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            jco_error = sw.toString();
            System.out.println(jco_error);
        }
        AboutDialog.Section section = new AboutDialog.Section("Versions");
        section.addEntry("JCo API", jco_version);
        section.addEntry("JCo middleware", middleware_version);
        section.addEntry("JCo library", libjrfc_version);
        section.addEntry("RFC library", librfc_numversion);
        this.addSection(section);
        section = new AboutDialog.Section("Library Paths");
        section.addEntry("Path to JCo archive", libjco_path == null ? SYS_PATH : libjco_path);
        section.addEntry("Path to JCo library", libjrfc_path == null ? NOT_FOUND : libjrfc_path);
        section.addEntry("Path to RFC library", librfc_path == null ? SYS_PATH : librfc_path);
        this.addSection(section);
        if (sap_codepage != null && sap_codepage.length() > 0 || rfc_trace != null && rfc_trace.length() > 0 || cpic_trace != null && cpic_trace.length() > 0) {
            section = new AboutDialog.Section("Environment");
            if (sap_codepage != null && sap_codepage.length() > 0) {
                section.addEntry("SAP_CODEPAGE", sap_codepage);
            }
            if (rfc_trace != null && rfc_trace.length() > 0) {
                section.addEntry("RFC_TRACE", rfc_trace);
            }
            if (cpic_trace != null && cpic_trace.length() > 0) {
                section.addEntry("CPIC_TRACE", cpic_trace);
            }
            this.addSection(section);
        }
        if (jco_error != null) {
            section = new AboutDialog.Section("Initialization");
            section.addEntry("JCo error", jco_error);
            this.addSection(section);
        }
    }

    public static void main(String[] args) {
        new About().show(args);
    }
}

