/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.dialect.pagination.SQLServer2005LimitHandler;
import org.hibernate.engine.spi.RowSelection;

public class SQLServer2012LimitHandler
extends SQLServer2005LimitHandler {
    public static final SQLServer2012LimitHandler INSTANCE = new SQLServer2012LimitHandler();

    private SQLServer2012LimitHandler() {
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        if (this.hasOrderBy(sql)) {
            if (!LimitHelper.useLimit(this, selection)) {
                return sql;
            }
            int firstRow = LimitHelper.hasFirstRow(selection) ? selection.getFirstRow() : 0;
            return sql + String.format(" offset %d rows fetch next %d rows only", firstRow, selection.getMaxRows());
        }
        return super.processSql(sql, selection);
    }

    private boolean hasOrderBy(String sql) {
        int depth = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '(') {
                ++depth;
            } else if (ch == ')') {
                --depth;
            }
            if (depth != 0 || !sql.substring(i).toLowerCase().startsWith("order by ")) continue;
            return true;
        }
        return false;
    }
}

